$(function(){
	var reports = $(".ier-reports .ier-report");
	var sections = [];
	var reports_total = reports.length;
	var last_report = reports_total - 1;
	
	
	$(".ier-reports .ier-report").not(".featured").each(function(){
		var report_id = "report-" + $(reports).index(this);
		var report_title = $(this).find(".ier-report-title").text();	
		var section = $(this).data("section");
		var section_id = section.replace(" ", "-").toLowerCase();
		$(this).attr("id",  report_id);
		$("#ier-dropdown-" + section_id).find("ul").append('<li><a href="#'+ report_id + '">'+report_title+'</a></li>');
		
		sections.push(section);
	});
	$(".ier-reports .ier-report.featured").each(function(){
		
		var report_id = "report-" + $(reports).index(this);
		var report_title = $(this).find(".ier-report-title").text();	
		var section = $(this).data("section");
		var section_id = section.replace(" ", "-").toLowerCase();
		$(this).attr("id",  report_id);
		if ($(this).is(".longtitle")) {
			console.log("tes");
			$("#ier-" + section_id).find(".ier-tabs .more").before('<li class="long"><a href="#'+ report_id + '">'+report_title+'</a></li>');
		} else {
			$("#ier-" + section_id).find(".ier-tabs .more").before('<li><a href="#'+ report_id + '">'+report_title+'</a></li>');			
		}


		sections.push(section);
	});
	function ier_load_section(section) {
		var target = $(section);
		$(".ier-section.active").hide();
		$(target).show().addClass("active");
		
		$('.ier-menu').find(".active").removeClass("active");
		$('.ier-menu').find('a[href="' + section + '"]').parent("li").addClass("active");

	}
	function ier_load_report(report) {
		var target = $(report);
		var report_html = $(target).html();
		var index = $(reports).index(target);
		var prev = index - 1;
		var next = index + 1;
		
		if(index == 0 ) {
			var prev = last_report;

		}
		if(index == last_report ) {
			var next = 0;
		}

		var prev_title = '<b>' + $("#report-" + prev).data("section") + ':</b> ' + $("#report-" + prev).find(".ier-report-title").text();
		var next_title = '<b>' + $("#report-" + next).data("section") + ':</b> ' + $("#report-" + next).find(".ier-report-title").text();
				
		
		$(".ier-next-report").attr("href", "#report-" + next).find("span").html(next_title);
		$(".ier-prev-report").attr("href", "#report-" + prev).find("span").html(prev_title);
		
		var section_name = $(target).data("section");	
		var section_id = section_name.replace(" ", "-").toLowerCase();
		var section_container = $(".ier-section#ier-" + section_id); 
		var report_container = $(section_container).find(".ier-report");
		var tabs = $(section_container).find(".ier-tabs");
		var section_reports = $('.ier-reports .ier-report[data-section="'+section_name+'"]');
		
				
		$(report_container).addClass("tst");
		$(report_container).hide();
		$(report_container).html(report_html);		
		$(report_container).fadeIn();
		ier_load_section('#ier-' + section_id);
		$(tabs).find(".active").removeClass("active");
		$(tabs).find('a[href="' + report + '"]').parent("li").addClass("active");
		
		
	}
	
	$(".ier-pagination a").click(function(){
		var target = $(this).attr("href");
		ier_load_report(target);
	});
	$(".ier-section").each(function(){
		var section = $(this);
		var dropdown = $(this).find(".ier-dropdown");
		var report_container = $(this).find(".ier-report");
		var tabs_contaner = $(this).find(".ier-tabs");
		$(dropdown).find("a").click(function(){
			$(report_container).hide();
			var target = $(this).attr("href");
			ier_load_report(target);
		});
		
		$(section).find(".ier-tabs li").not(".more").find("a").click(function(){
			
			var target = $(this).attr("href");
			ier_load_report(target);
		});
		
	});
	
	$(".ier-menu li a").click(function(e){
		e.preventDefault();
		
		var target = $(this).attr("href");
		var section_name = $(this).text().trim();
		var report = $('.ier-reports .ier-report[data-section="'+section_name+'"]').first();
		ier_load_report('#' + $(report).attr("id"));
	});
	var hash = window.location.hash;
	if(hash) {
	 	ier_load_report(hash);	 	
	} else {
		ier_load_report('#report-0');
	}
	
});