﻿var CaptchaCallback = function () {
    $('.g-recaptcha').each(function (index, el) {
        grecaptcha.render(el, { 'sitekey': '6Leo1BkTAAAAAMYTq_G-8vpIQkdWsZK3WzfOu12d' });
    });
};

var RecProductEmail = {
    init: function () {

    },

    GoForm: function (clickType) {
        var emailSubject = document.getElementById('frmSubject');
        var emailType = document.getElementById('frmType');

        if (clickType === 1) {
            emailSubject.value = 'Recruiter Product Contact Request';
            emailType.value = '1';
            document.getElementById('tSolutions').style.display = 'block';
        }

        if (clickType === 2) {
            emailSubject.value = 'Recruiter Price Quote Request';
            emailType.value = '2';
            document.getElementById('tSolutions').style.display = 'none';
        }

        document.getElementById('recContact').scrollIntoView();
        console.log(emailSubject.value);
        console.log(emailType.value);

        return false;
    },

    SendEmail: function () {

        if (RecProductEmail.checkValues() === false) {
            return false;
        }

        var emailType = document.getElementById('frmType');

        $.ajax({
            type: "POST",
            url: "/recruiters/productsEmail/",
            dataType: 'json',
            data: $('#frmRecContact').serializeArray(),
            success: function (data) {
                var response = $.parseJSON(data);
                console.log(data);
                console.log(response);
                if (response.Status === "Success") {
                    $("#tSolutions").hide();
                    $("#recContactForm").hide();
                    $("#frmResults").show();
                    if (emailType.value == '1') {
                        $("#frmResults").html("Thank you contacting Rigzone, the no. 1 oil and gas resource, we will be in touch with you shortly.<br>");
                    }
                    if (emailType.value == '2') {
                        $("#frmResults").html("Thank you, we have received your request and we will be in touch with you shortly.<br>");
                    }

                    $("#recContactForm").hide();
                } else if (response.Status === "Failed") {
                    RecProductEmail.showError(response.Message);
                }
            },
            error: function (data) {
                RecProductEmail.showError(data.message);
            }
        });
        return false;
    },

    checkValues: function () {
        var message = '';
        // we are doing this all server side
        //just keep it there.
        if (grecaptcha.getResponse().length == 0) {
            message += 'Error encountered. Please verify reCAPTCHA<br/>';
        }

        if (document.getElementById("FirstName").value.length < 1) {
            message += 'Please provide a first name.<br/>';
        }

        if (document.getElementById("LastName").value.length < 1) {
            message += 'Please provide a last name.<br/>';
        }

        if (document.getElementById("JobTitle").value.length < 1) {
            message += 'Please provide a job title.<br/>';
        }

        if (document.getElementById("Company").value.length < 1) {
            message += 'Please provide a Company.<br/>';
        }

        if (document.getElementById("CountryID").value.length < 1) {
            message += 'Please select a country.<br/>';
        }

        if (document.getElementById("Telephone").value.length < 1) {
            message += 'Please provide a contact telephone.<br/>';
        }

        if (document.getElementById("Email").value.length < 3 || !this.isValidEmailAddress(document.getElementById("Email").value)) {
            message += 'Please provide a contact email.<br/>';
        }

        if (message != '') {
            RecProductEmail.showError(message);

            return false;
        }
        return true;
    },

    isValidEmailAddress: function (emailAddress) {
        var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
        return pattern.test(emailAddress);
    },
    showError: function (message) {
        $("#frmResults").show();
        $("#frmResults").html(message);
        $("#tSolutions").hide();
        $("#frmResults").css("color", "red");
        document.getElementById('frmResults').scrollIntoView();
    },

    showDialog: function () {
        var myurl = '/jobs/Resume_Search_No_Subscription_Modal.asp';
        $('#iframedialog').attr('src', myurl).attr('style', 'width:100%; height:100%;border:none;');

        $('#mydialog').dialog({
            height: '350',
            width: '650',
            position: { my: 'center', at: 'top', of: window },
            title: 'No Subscription Found',
            draggable: false,
            closeOnEscape: true,
            resizable: false
        });
    },

};