﻿$(document).ready(function() {
    $('#careernews').load('/careerrelated.html');
});
    
// page init
jQuery(function () {
    initTabs();
    initRating();
    initBackgroundResize();
    initSameHeight();
    initTabsToAccordion();
    initSearchOpenClose();
});



// content tabs init
function initTabs() {
	jQuery('ul.tabset:not(.js-custom-tabset)').contentTabs({
		addToParent: true,
		animSpeed: 400,
       // effect: 'slide',
		tabLinks: 'a'
	});
	jQuery('ul.tabset').trigger('destroy.tabs');
	jQuery('ul.job-heading').contentTabs({
	    addToParent: true,
	    animSpeed: 400,
	    tabLinks: 'a'
	});
}

function initTabsToAccordion() {
    // handle layout resize
    ResponsiveHelper.addRange({
        '..767': {
            on: function () {
                jQuery('ul.js-custom-tabset + .content-holder').slideAccordion({
                    opener: 'a.slide-opener',
                    slider: '.slide',
                    animSpeed: 300
                });
            },
            off: function () {
                jQuery('ul.js-custom-tabset + .content-holder').trigger('destroy.accordion');
            }
        },
        '768..': {
            on: function () {
                jQuery('ul.js-custom-tabset').contentTabs({
                    addToParent: true,
                    animSpeed: 400,
                    effect: 'none',
                    tabLinks: 'a'
                });
            },
            off: function () {
                jQuery('ul.js-custom-tabset').trigger('destroy.tabs');
            }
        }
    });
}

// open-close init
function initSearchOpenClose() {
    jQuery('.job-search-form').openClose({
        hideOnClickOutside: true,
        activeClass: 'active',
        opener: '.opener',
        slider: '.advance-search',
        animSpeed: 400,
        effect: 'slide'
    });
}

// star rating init
function initRating() {
    lib.each(lib.queryElementsBySelector('ul.rating'), function () {
        new StarRating({
            element: this,
            onselect: function (num) {
                // rating setted event
            }
        });
    });
}


// initialize fixed blocks on scroll
function initFixedScrollBlock() {
    var win = jQuery(window);
    var winTop = win.scrollTop();
    var activeClass = 'fixed-position';

    jQuery('#header').each(function () {
        var header = jQuery(this);
        var fakeBox = jQuery('<div class="fake-header"></div>').insertAfter(header).css({
            display: 'none',
            height: header.outerHeight(true)
        });
        var isFixed = false;
        var offset = header.offset().top;

        resizeHandler();
        win.on('resize orientationchange load', resizeHandler);
        win.on('scroll', scrollHandler);

        function scrollHandler() {
            winTop = win.scrollTop();

            if (winTop > offset) {
                if (!isFixed) {
                    header.addClass(activeClass);
                    fakeBox.show();
                    isFixed = true;
                }
            } else {
                if (isFixed) {
                    header.removeClass(activeClass);
                    fakeBox.hide();
                    isFixed = false;
                }
            }
        }

        function resizeHandler() {
            fakeBox.hide();
            header.removeClass(activeClass);
            offset = header.offset().top;
            fakeBox.css({ height: header.outerHeight(true) });
            isFixed = false;
            scrollHandler();
        }
    });
}

// stretch background to fill blocks
function initBackgroundResize() {
    jQuery('.bg-stretch').each(function () {
        ImageStretcher.add({
            container: this,
            image: 'img'
        });
    });
}

// align blocks height
function initSameHeight() {
    jQuery('.panels').sameHeight({
        elements: '.panel',
        flexible: true
    });
}
/*
 * Responsive Layout helper
 */
ResponsiveHelper = (function ($) {
    // init variables
    var handlers = [],
		prevWinWidth,
		win = $(window),
		nativeMatchMedia = false;

    // detect match media support
    if (window.matchMedia) {
        if (window.Window && window.matchMedia === Window.prototype.matchMedia) {
            nativeMatchMedia = true;
        } else if (window.matchMedia.toString().indexOf('native') > -1) {
            nativeMatchMedia = true;
        }
    }

    // prepare resize handler
    function resizeHandler() {
        var winWidth = win.width();
        if (winWidth !== prevWinWidth) {
            prevWinWidth = winWidth;

            // loop through range groups
            $.each(handlers, function (index, rangeObject) {
                // disable current active area if needed
                $.each(rangeObject.data, function (property, item) {
                    if (item.currentActive && !matchRange(item.range[0], item.range[1])) {
                        item.currentActive = false;
                        if (typeof item.disableCallback === 'function') {
                            item.disableCallback();
                        }
                    }
                });

                // enable areas that match current width
                $.each(rangeObject.data, function (property, item) {
                    if (!item.currentActive && matchRange(item.range[0], item.range[1])) {
                        // make callback
                        item.currentActive = true;
                        if (typeof item.enableCallback === 'function') {
                            item.enableCallback();
                        }
                    }
                });
            });
        }
    }
    win.bind('load resize orientationchange', resizeHandler);

    // test range
    function matchRange(r1, r2) {
        var mediaQueryString = '';
        if (r1 > 0) {
            mediaQueryString += '(min-width: ' + r1 + 'px)';
        }
        if (r2 < Infinity) {
            mediaQueryString += (mediaQueryString ? ' and ' : '') + '(max-width: ' + r2 + 'px)';
        }
        return matchQuery(mediaQueryString, r1, r2);
    }

    // media query function
    function matchQuery(query, r1, r2) {
        if (window.matchMedia && nativeMatchMedia) {
            return matchMedia(query).matches;
        } else if (window.styleMedia) {
            return styleMedia.matchMedium(query);
        } else if (window.media) {
            return media.matchMedium(query);
        } else {
            return prevWinWidth >= r1 && prevWinWidth <= r2;
        }
    }

    // range parser
    function parseRange(rangeStr) {
        var rangeData = rangeStr.split('..');
        var x1 = parseInt(rangeData[0], 10) || -Infinity;
        var x2 = parseInt(rangeData[1], 10) || Infinity;
        return [x1, x2].sort(function (a, b) {
            return a - b;
        });
    }

    // export public functions
    return {
        addRange: function (ranges) {
            // parse data and add items to collection
            var result = { data: {} };
            $.each(ranges, function (property, data) {
                result.data[property] = {
                    range: parseRange(property),
                    enableCallback: data.on,
                    disableCallback: data.off
                };
            });
            handlers.push(result);

            // call resizeHandler to recalculate all events
            prevWinWidth = null;
            resizeHandler();
        }
    };
}(jQuery));

/*
 * jQuery Accordion plugin
 */
; (function ($) {
    $.fn.slideAccordion = function (opt) {
        // default options
        var options = $.extend({
            addClassBeforeAnimation: false,
            allowClickWhenExpanded: false,
            activeClass: 'active',
            opener: '.opener',
            slider: '.slide',
            animSpeed: 300,
            collapsible: true,
            event: 'click'
        }, opt);

        return this.each(function () {
            // options
            var accordion = $(this);
            var items = accordion.find(':has(' + options.slider + ')');

            items.each(function () {
                var item = $(this);
                var opener = item.find(options.opener);
                var slider = item.find(options.slider);
                opener.bind(options.event + '.toggleSlide', function (e) {
                    if (!slider.is(':animated')) {
                        if (item.hasClass(options.activeClass)) {
                            if (options.allowClickWhenExpanded) {
                                return;
                            } else if (options.collapsible) {
                                slider.slideUp(options.animSpeed, function () {
                                    hideSlide(slider);
                                    item.removeClass(options.activeClass);
                                });
                            }
                        } else {
                            // show active
                            var levelItems = item.siblings('.' + options.activeClass);
                            var sliderElements = levelItems.find(options.slider);
                            item.addClass(options.activeClass);
                            showSlide(slider).hide().slideDown(options.animSpeed);

                            // collapse others
                            sliderElements.slideUp(options.animSpeed, function () {
                                levelItems.removeClass(options.activeClass);
                                hideSlide(sliderElements);
                            });
                        }
                    }
                    e.preventDefault();
                });
                if (item.hasClass(options.activeClass)) showSlide(slider); else hideSlide(slider);
            });
            accordion.on('destroy.accordion', destroy);
            function destroy() {
                items.removeClass(options.activeClass).each(function () {
                    var item = $(this);
                    var opener = item.find(options.opener);
                    var slider = item.find(options.slider).removeAttr('style');
                    opener.unbind(options.event + '.toggleSlide')
                });
            }
        });
    };

    // accordion slide visibility
    var showSlide = function (slide) {
        return slide.css({ position: '', top: '', left: '', width: '' });
    };
    var hideSlide = function (slide) {
        return slide.show().css({ position: 'absolute', top: -9999, left: -9999, width: slide.width() });
    };
}(jQuery));


/*
 * jQuery Tabs plugin
 */
; (function ($) {
    $.fn.contentTabs = function (o) {
        // default options
        var options = $.extend({
            activeClass: 'active',
            addToParent: false,
            autoHeight: false,
            autoRotate: false,
            checkHash: false,
            animSpeed: 400,
            switchTime: 3000,
            effect: 'none', // "fade", "slide"
            tabLinks: 'a',
            attrib: 'href',
            event: 'click'
        }, o);

        return this.each(function () {
            var tabset = $(this), tabs = $();
            var tabLinks = tabset.find(options.tabLinks);
            var tabLinksParents = tabLinks.parent();
            var prevActiveLink = tabLinks.eq(0), currentTab, animating;
            var tabHolder;

            // handle location hash
            if (options.checkHash && tabLinks.filter('[' + options.attrib + '="' + location.hash + '"]').length) {
                (options.addToParent ? tabLinksParents : tabLinks).removeClass(options.activeClass);
                setTimeout(function () {
                    window.scrollTo(0, 0);
                }, 1);
            }

            // init tabLinks
            tabLinks.each(function () {
                var link = $(this);
                var href = link.attr(options.attrib);
                var parent = link.parent();
                href = href.substr(href.lastIndexOf('#'));

                // get elements
                var tab = $(href).hide().addClass(tabHiddenClass);
                tabs = tabs.add(tab);
                link.data('cparent', parent);
                link.data('ctab', tab);

                // find tab holder
                if (!tabHolder && tab.length) {
                    tabHolder = tab.parent();
                }

                // show only active tab
                var classOwner = options.addToParent ? parent : link;
                if (classOwner.hasClass(options.activeClass) || (options.checkHash && location.hash === href)) {
                    classOwner.addClass(options.activeClass);
                    prevActiveLink = link; currentTab = tab;
                    tab.removeClass(tabHiddenClass).width('');
                    contentTabsEffect[options.effect].show({ tab: tab, fast: true });
                } else {
                    var tabWidth = tab.width();
                    if (tabWidth) {
                        tab.width(tabWidth);
                    }
                    tab.addClass(tabHiddenClass);
                }

                // event handler
                link.bind(options.event + '.openTab', function (e) {
                    if (link != prevActiveLink && !animating) {
                        switchTab(prevActiveLink, link);
                        prevActiveLink = link;
                    }
                });
                if (options.attrib === 'href') {
                    link.bind('click', function (e) {
                        e.preventDefault();
                    });
                }
            });

            // tab switch function
            function switchTab(oldLink, newLink) {
                animating = true;
                var oldTab = oldLink.data('ctab');
                var newTab = newLink.data('ctab');
                prevActiveLink = newLink;
                currentTab = newTab;

                // refresh pagination links
                (options.addToParent ? tabLinksParents : tabLinks).removeClass(options.activeClass);
                (options.addToParent ? newLink.data('cparent') : newLink).addClass(options.activeClass);

                // hide old tab
                resizeHolder(oldTab, true);
                contentTabsEffect[options.effect].hide({
                    speed: options.animSpeed,
                    tab: oldTab,
                    complete: function () {
                        // show current tab
                        resizeHolder(newTab.removeClass(tabHiddenClass).width(''));
                        contentTabsEffect[options.effect].show({
                            speed: options.animSpeed,
                            tab: newTab,
                            complete: function () {
                                if (!oldTab.is(newTab)) {
                                    oldTab.width(oldTab.width()).addClass(tabHiddenClass);
                                }
                                animating = false;
                                resizeHolder(newTab, false);
                                autoRotate();
                                $(window).trigger('resize');
                            }
                        });
                    }
                });
            }

            // holder auto height
            function resizeHolder(block, state) {
                var curBlock = block && block.length ? block : currentTab;
                if (options.autoHeight && curBlock) {
                    tabHolder.stop();
                    if (state === false) {
                        tabHolder.css({ height: '' });
                    } else {
                        var origStyles = curBlock.attr('style');
                        curBlock.show().css({ width: curBlock.width() });
                        var tabHeight = curBlock.outerHeight(true);
                        if (!origStyles) curBlock.removeAttr('style'); else curBlock.attr('style', origStyles);
                        if (state === true) {
                            tabHolder.css({ height: tabHeight });
                        } else {
                            tabHolder.animate({ height: tabHeight }, { duration: options.animSpeed });
                        }
                    }
                }
            }
            if (options.autoHeight) {
                $(window).bind('resize orientationchange', function () {
                    tabs.not(currentTab).removeClass(tabHiddenClass).show().each(function () {
                        var tab = jQuery(this), tabWidth = tab.css({ width: '' }).width();
                        if (tabWidth) {
                            tab.width(tabWidth);
                        }
                    }).hide().addClass(tabHiddenClass);

                    resizeHolder(currentTab, false);
                });
            }

            // autorotation handling
            var rotationTimer;
            function nextTab() {
                var activeItem = (options.addToParent ? tabLinksParents : tabLinks).filter('.' + options.activeClass);
                var activeIndex = (options.addToParent ? tabLinksParents : tabLinks).index(activeItem);
                var newLink = tabLinks.eq(activeIndex < tabLinks.length - 1 ? activeIndex + 1 : 0);
                prevActiveLink = tabLinks.eq(activeIndex);
                switchTab(prevActiveLink, newLink);
            }
            function autoRotate() {
                if (options.autoRotate && tabLinks.length > 1) {
                    clearTimeout(rotationTimer);
                    rotationTimer = setTimeout(function () {
                        if (!animating) {
                            nextTab();
                        } else {
                            autoRotate();
                        }
                    }, options.switchTime);
                }
            }
            autoRotate();

            tabset.on('destroy.tabs', destroy);
            function destroy() {
                clearTimeout(rotationTimer);
                animating = false;
                (options.addToParent ? tabLinksParents : tabLinks).removeClass(options.activeClass);
                tabs.width('').removeClass(tabHiddenClass);
                tabHolder.css({ height: '' });
                tabLinks.unbind(options.event + '.openTab');
            }
        });
    };

    // add stylesheet for tabs on DOMReady
    var tabHiddenClass = 'js-tab-hidden';
    (function () {
        var tabStyleSheet = $('<style type="text/css">')[0];
        var tabStyleRule = '.' + tabHiddenClass;
        tabStyleRule += '{position:absolute !important;left:-9999px !important;top:-9999px !important;display:block !important}';
        if (tabStyleSheet.styleSheet) {
            tabStyleSheet.styleSheet.cssText = tabStyleRule;
        } else {
            tabStyleSheet.appendChild(document.createTextNode(tabStyleRule));
        }
        $('head').append(tabStyleSheet);
    }());

    // tab switch effects
    var contentTabsEffect = {
        none: {
            show: function (o) {
                o.tab.css({ display: 'block' });
                if (o.complete) o.complete();
            },
            hide: function (o) {
                o.tab.css({ display: 'none' });
                if (o.complete) o.complete();
            }
        },
        fade: {
            show: function (o) {
                if (o.fast) o.speed = 1;
                o.tab.fadeIn(o.speed);
                if (o.complete) setTimeout(o.complete, o.speed);
            },
            hide: function (o) {
                if (o.fast) o.speed = 1;
                o.tab.fadeOut(o.speed);
                if (o.complete) setTimeout(o.complete, o.speed);
            }
        },
        slide: {
            show: function (o) {
                var tabHeight = o.tab.show().css({ width: o.tab.width() }).outerHeight(true);
                var tmpWrap = $('<div class="effect-div">').insertBefore(o.tab).append(o.tab);
                tmpWrap.css({ width: '100%', overflow: 'hidden', position: 'relative' }); o.tab.css({ marginTop: -tabHeight, display: 'block' });
                if (o.fast) o.speed = 1;
                o.tab.animate({ marginTop: 0 }, {
                    duration: o.speed, complete: function () {
                        o.tab.css({ marginTop: '', width: '' }).insertBefore(tmpWrap);
                        tmpWrap.remove();
                        if (o.complete) o.complete();
                    }
                });
            },
            hide: function (o) {
                var tabHeight = o.tab.show().css({ width: o.tab.width() }).outerHeight(true);
                var tmpWrap = $('<div class="effect-div">').insertBefore(o.tab).append(o.tab);
                tmpWrap.css({ width: '100%', overflow: 'hidden', position: 'relative' });

                if (o.fast) o.speed = 1;
                o.tab.animate({ marginTop: -tabHeight }, {
                    duration: o.speed, complete: function () {
                        o.tab.css({ display: 'none', marginTop: '', width: '' }).insertBefore(tmpWrap);
                        tmpWrap.remove();
                        if (o.complete) o.complete();
                    }
                });
            }
        }
    };
}(jQuery));

/*
 * jQuery SameHeight plugin
 */
; (function ($) {
    $.fn.sameHeight = function (opt) {
        var options = $.extend({
            skipClass: 'same-height-ignore',
            leftEdgeClass: 'same-height-left',
            rightEdgeClass: 'same-height-right',
            elements: '>*',
            flexible: false,
            multiLine: false,
            useMinHeight: false,
            biggestHeight: false
        }, opt);
        return this.each(function () {
            var holder = $(this), postResizeTimer, ignoreResize;
            var elements = holder.find(options.elements).not('.' + options.skipClass);
            if (!elements.length) return;

            // resize handler
            function doResize() {
                elements.css(options.useMinHeight && supportMinHeight ? 'minHeight' : 'height', '');
                if (options.multiLine) {
                    // resize elements row by row
                    resizeElementsByRows(elements, options);
                } else {
                    // resize elements by holder
                    resizeElements(elements, holder, options);
                }
            }
            doResize();

            // handle flexible layout / font resize
            var delayedResizeHandler = function () {
                if (!ignoreResize) {
                    ignoreResize = true;
                    doResize();
                    clearTimeout(postResizeTimer);
                    postResizeTimer = setTimeout(function () {
                        doResize();
                        setTimeout(function () {
                            ignoreResize = false;
                        }, 10);
                    }, 100);
                }
            };

            // handle flexible/responsive layout
            if (options.flexible) {
                $(window).bind('resize orientationchange fontresize', delayedResizeHandler);
            }

            // handle complete page load including images and fonts
            $(window).bind('load', delayedResizeHandler);
        });
    };

    // detect css min-height support
    var supportMinHeight = typeof document.documentElement.style.maxHeight !== 'undefined';

    // get elements by rows
    function resizeElementsByRows(boxes, options) {
        var currentRow = $(), maxHeight, maxCalcHeight = 0, firstOffset = boxes.eq(0).offset().top;
        boxes.each(function (ind) {
            var curItem = $(this);
            if (curItem.offset().top === firstOffset) {
                currentRow = currentRow.add(this);
            } else {
                maxHeight = getMaxHeight(currentRow);
                maxCalcHeight = Math.max(maxCalcHeight, resizeElements(currentRow, maxHeight, options));
                currentRow = curItem;
                firstOffset = curItem.offset().top;
            }
        });
        if (currentRow.length) {
            maxHeight = getMaxHeight(currentRow);
            maxCalcHeight = Math.max(maxCalcHeight, resizeElements(currentRow, maxHeight, options));
        }
        if (options.biggestHeight) {
            boxes.css(options.useMinHeight && supportMinHeight ? 'minHeight' : 'height', maxCalcHeight);
        }
    }

    // calculate max element height
    function getMaxHeight(boxes) {
        var maxHeight = 0;
        boxes.each(function () {
            maxHeight = Math.max(maxHeight, $(this).outerHeight());
        });
        return maxHeight;
    }

    // resize helper function
    function resizeElements(boxes, parent, options) {
        var calcHeight;
        var parentHeight = typeof parent === 'number' ? parent : parent.height();
        boxes.removeClass(options.leftEdgeClass).removeClass(options.rightEdgeClass).each(function (i) {
            var element = $(this);
            var depthDiffHeight = 0;
            var isBorderBox = element.css('boxSizing') === 'border-box' || element.css('-moz-box-sizing') === 'border-box' || element.css('-webkit-box-sizing') === 'border-box';

            if (typeof parent !== 'number') {
                element.parents().each(function () {
                    var tmpParent = $(this);
                    if (parent.is(this)) {
                        return false;
                    } else {
                        depthDiffHeight += tmpParent.outerHeight() - tmpParent.height();
                    }
                });
            }
            calcHeight = parentHeight - depthDiffHeight;
            calcHeight -= isBorderBox ? 0 : element.outerHeight() - element.height();

            if (calcHeight > 0) {
                element.css(options.useMinHeight && supportMinHeight ? 'minHeight' : 'height', calcHeight);
            }
        });
        boxes.filter(':first').addClass(options.leftEdgeClass);
        boxes.filter(':last').addClass(options.rightEdgeClass);
        return calcHeight;
    }
}(jQuery));

/*
 * jQuery FontResize Event
 */
jQuery.onFontResize = (function ($) {
    $(function () {
        var randomID = 'font-resize-frame-' + Math.floor(Math.random() * 1000);
        var resizeFrame = $('<iframe>').attr('id', randomID).addClass('font-resize-helper');

        // required styles
        resizeFrame.css({
            width: '100em',
            height: '10px',
            position: 'absolute',
            borderWidth: 0,
            top: '-9999px',
            left: '-9999px'
        }).appendTo('body');

        // use native IE resize event if possible
        if (window.attachEvent && !window.addEventListener) {
            resizeFrame.bind('resize', function () {
                $.onFontResize.trigger(resizeFrame[0].offsetWidth / 100);
            });
        }
            // use script inside the iframe to detect resize for other browsers
        else {
            var doc = resizeFrame[0].contentWindow.document;
			var head = doc.getElementsByTagName("head")[0];
			head.innerHTML = '<scri' + 'pt>window.onload = function(){var em = parent.jQuery("#' + randomID + '")[0];window.onresize = function(){if(parent.jQuery.onFontResize){parent.jQuery.onFontResize.trigger(em.offsetWidth / 100);}}};</scri' + 'pt>';
        }
        jQuery.onFontResize.initialSize = resizeFrame[0].offsetWidth / 100;
    });
    return {
        // public method, so it can be called from within the iframe
        trigger: function (em) {
            $(window).trigger("fontresize", [em]);
        }
    };
}(jQuery));


/*
 * Simple star rating module
 */
function StarRating() {
    this.options = {
        activeClass: 'active',
        settedClass: 'setted',
        element: null,
        items: null,
        onselect: null
    };
    this.init.apply(this, arguments);
}
StarRating.prototype = {
    init: function (opt) {
        this.setOptions(opt);
        if (this.element) {
            this.getElements();
           // this.addEvents();
        }
    },
    setOptions: function (opt) {
        for (var p in opt) {
            if (opt.hasOwnProperty(p)) {
                this.options[p] = opt[p];
            }
        }
        if (this.options.element) {
            this.element = this.options.element;
        }
    },
    getElements: function () {
        // get switch objects
        if (this.options.items === null) {
            this.items = this.element.children;
        } else {
            if (typeof this.options.items === 'string') {
                this.items = this.element.getElementsByTagName(this.options.items);
            } else if (typeof this.options.items === 'object') {
                this.items = this.options.items;
            }
        }

        // find default active index
        for (var i = 0; i < this.items.length; i++) {
            if (lib.hasClass(this.items[i], this.options.activeClass)) {
                this.activeIndex = i;
            }
            if (lib.hasClass(this.items[i], this.options.settedClass)) {
                this.settedIndex = i;
            }
        }
    },
    addEvents: function () {
        for (var i = 0; i < this.items.length; i++) {
            this.items[i].onmouseover = lib.bind(this.overHandler, this, i);
            this.items[i].onmouseout = lib.bind(this.outHandler, this, i);
            this.items[i].onclick = lib.bind(this.clickHandler, this, i);
        }
    },
    overHandler: function (ind) {
        this.hovering = true;
        this.hoverIndex = ind;
        this.refreshClasses();
    },
    outHandler: function (ind) {
        this.hovering = false;
        this.refreshClasses();
    },
    clickHandler: function (ind) {
        this.hovering = false;
        this.settedIndex = ind;
        if (typeof this.options.onselect === 'function') {
            this.options.onselect(ind);
        }
        this.refreshClasses();
        return false;
    },
    refreshClasses: function () {
        for (var i = 0; i < this.items.length; i++) {
            lib.removeClass(this.items[i], this.options.activeClass);
            lib.removeClass(this.items[i], this.options.settedClass);
        }
        if (this.hovering) {
            lib.addClass(this.items[this.hoverIndex], this.options.activeClass);
        } else {
            if (typeof this.settedIndex === 'number') {
                lib.addClass(this.items[this.settedIndex], this.options.settedClass);
            } else {
                if (typeof this.activeIndex === 'number') {
                    lib.addClass(this.items[this.activeIndex], this.options.activeClass);
                }
            }
        }
    }
};

/*
 * Image Stretch module
 */
var ImageStretcher = {
    getDimensions: function (data) {
        // calculate element coords to fit in mask
        var ratio = data.imageRatio || (data.imageWidth / data.imageHeight),
			slideWidth = data.maskWidth,
			slideHeight = slideWidth / ratio;

        if (slideHeight < data.maskHeight) {
            slideHeight = data.maskHeight;
            slideWidth = slideHeight * ratio;
        }
        return {
            width: slideWidth,
            height: slideHeight,
            top: (data.maskHeight - slideHeight) / 2,
            left: (data.maskWidth - slideWidth) / 2
        };
    },
    getRatio: function (image) {
        if (image.prop('naturalWidth')) {
            return image.prop('naturalWidth') / image.prop('naturalHeight');
        } else {
            var img = new Image();
            img.src = image.prop('src');
            return img.width / img.height;
        }
    },
    imageLoaded: function (image, callback) {
        var self = this;
        var loadHandler = function () {
            callback.call(self);
        };
        if (image.prop('complete')) {
            loadHandler();
        } else {
            image.one('load', loadHandler);
        }
    },
    resizeHandler: function () {
        var self = this;
        jQuery.each(this.imgList, function (index, item) {
            if (item.image.prop('complete')) {
                self.resizeImage(item.image, item.container);
            }
        });
    },
    resizeImage: function (image, container) {
        this.imageLoaded(image, function () {
            var styles = this.getDimensions({
                imageRatio: this.getRatio(image),
                maskWidth: container.width(),
                maskHeight: container.height()
            });
            image.css({
                width: styles.width,
                height: styles.height,
                marginTop: styles.top,
                marginLeft: styles.left
            });
        });
    },
    add: function (options) {
        var container = jQuery(options.container ? options.container : window),
			image = typeof options.image === 'string' ? container.find(options.image) : jQuery(options.image);

        // resize image
        this.resizeImage(image, container);

        // add resize handler once if needed
        if (!this.win) {
            this.resizeHandler = jQuery.proxy(this.resizeHandler, this);
            this.imgList = [];
            this.win = jQuery(window);
            this.win.on('resize orientationchange', this.resizeHandler);
        }

        // store item in collection
        this.imgList.push({
            container: container,
            image: image
        });
    }
};


// accordion menu init
function initAccordion() {
    //jQuery('ul.filters').slideAccordion({
    //    opener: '.opener',
    //    slider: '.filter-form',
    //    animSpeed: 300
    //});

    jQuery(document).ready(function () {
        $('ul.filters li a').click(function () {
            $($(this).next()).toggle();
            $($(this).parent()).toggleClass('active');
           
            return false;
        });

        $.each($('ul.filters li  form'), function(index, item) {
            if ($(item).has('input:checked').length > 0) {
               if($($(item).prev()).is('a'))
                    $($(item).prev()).click();
            }
        });
    });
}


var SocialBarEmail = {
	EmailDisplayCount: function (txtUserText, cntUserText) {
		if (txtUserText.value.length > 0) {
			document.getElementById(cntUserText).innerHTML = " (" + txtUserText.value.length + "/200)";
		} else { document.getElementById(cntUserText).innerHTML = ""; }
	}
};


